


/******************************************************************************************
 *                                                                                        *
 * Ex2.  :   Read  ASCII Code From Touch PAD Key 4x4 Out Hex Code To LED D8..D13          *
 *           By Use Interupt Recive ASCII Code                                            *
 *           (Format: Key Shif + Key Other(Key0-9) )                                      *
 *                                                                                        *
 ******************************************************************************************
 *                                                                                        *
 * Target MCU      : ATMEGA168(ET-BASE AVR EASY MEGA168)                                  *
 *                 : X-TAL : 16 MHz                                                       *
 *                                                                                        *
 * Compiler Editor : Arduino 1.0.4                                                        *
 * Create By       : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                 *
 * Last Update     : 12/September/2014                                                    *
 *                                                                                        *
 * Port Interface  :  -- MCU-AT MEGA168--                   -- Key Touch PAD 4x4 --       *  
 *                                                                                        *
 *       Uart0    :  D0 = TXDO          Connect                Rx of Board Touch Key      *  
 *                   D1 = RXD0          Connect                Tx of Board Touch Key      *
 *                   Baud Rate = 9600  at Clock 16 MHz                                    *
 *                                                                                        *
 *    LED DISPLAY : D[8..13]              Connect                 LED Common Anode        *
 *                                                                                        *  
 *                                                                             5V         *
 *                                                                             -+-        *
 *                                                              560      \\     |         *
 *                                                     D8 -----/\/\/\---|<|-----+         *
 *                                                                       .      |         *
 *                                                              560      . \\   |         *
 *                                                    D13 -----/\/\/\-----|<|---+         *
 *                                                                                        *
 *                                                                                        *
 *   Operation  : When Touch Key(0-9)or Key Shift+Key other(0-9) will Show                *
 *                Key Code(Hex of Ascii) on LED D8..D13                                   *
 *                                                                                        *
 ******************************************************************************************/


  unsigned char key[3] ,n=0                    ;


//----------- Defind LED Display Port D8..D13 ---------------- 

#define LED0           8      //D8
#define LED1           9      //D9
#define LED2          10      //D10   
#define LED3          11      //D11
#define LED4          12      //D12
#define LED5          13      //D13


/*********************************************************************************
 **                                                                             **
 **                  Read ASCII Key Code From RS232 Touch PAD4x4                **
 **                                                                             **
 *********************************************************************************/
 
void RD_KeyCode()
 {
   unsigned char ch ;
   
        if(Serial.available() > 0)      // send data only when you receive data:
          {                
            ch = Serial.read()    ;     //Read Ascii Key Code 1 byte
            key[n] = ch           ;
            n++                   ; 

            if(n == 3)                  //if Pointer= 3 Clear Pointer=0
               n=0                ;
	 }                              // End Receive data 

 }


/*##########################################################################
  ##                                                                      ##
  ##                               SETUP                                  ##
  ##                                                                      ##
  ##########################################################################*/



void setup() 
{ 
 //------------Initial Port D8..D13 =Output for LED Display --------------- 
  
    pinMode(LED0,OUTPUT)           ; //Set Status pin D8  = Output  
    pinMode(LED1,OUTPUT)           ; //Set Status pin D9  = Output  
    pinMode(LED2,OUTPUT)           ; //Set Status pin D10 = Output  
    pinMode(LED3,OUTPUT)           ; //Set Status pin D11 = Output  
    pinMode(LED4,OUTPUT)           ; //Set Status pin D12 = Output  
    pinMode(LED5,OUTPUT)           ; //Set Status pin D13 = Output 
    
    //--------Set Default D8..D13 = 0xFF for OFF LED ---------
    
    digitalWrite(LED0,HIGH)        ; //SET LED0-OFF          
    digitalWrite(LED1,HIGH)        ; //SET LED1-OFF   
    digitalWrite(LED2,HIGH)        ; //SET LED2-OFF   
    digitalWrite(LED3,HIGH)        ; //SET LED3-OFF   
    digitalWrite(LED4,HIGH)        ; //SET LED4-OFF   
    digitalWrite(LED5,HIGH)        ; //SET LED5-OFF   
 
 //--------------------- Initial UART0 -(D0=Tx ,D1=Rx)----------------------
 
    Serial.begin(9600)             ;  //Set Board Rate Uart0 =9600
  
}



/*#######################################################################
 ##                                                                    ##
 ##                        MAIN PROGRAM                                ##
 ##                                                                    ##
 #######################################################################*/
 

void loop() 
{ 
  char dd ;
  
   RD_KeyCode() ;                       //Step1: Read ASCII Code 3 Byte
     
   if(key[2] == 0x0D)                   //Step2: Check data Last Byte readded              
        {
          key[2] =0 ;                   //Step3: Clear data in buffer array key[2]
         
         if(key[0]=='P')               //Step4: Check  Status  Pressed key (ASCII Code = 'P')
          {
            if(key[1]=='F')            //Step5: Check Touch Key Shift(ASCII Code='F')
             {
               do                      //Loop wait Touch the 2nd Key when Key Shif is touched
               {
                 RD_KeyCode() ;       //Read ASCII Code 3 Byte
                
                 if(key[2] == 0x0D)    //Step5.1: Check data last Byte for Touch the 2nd Key
                  {
                    key[2] = 0    ;    //Clear data in buffer array key[2]
                  
                   if(key[0] == 'F')   //Step5.2: Check Status Touch the 2nd Key
                    {
                      //----------- Step5.3: Write Program Support Touch Key Shif+Key Other of User ------------
                                         
                       if((key[1]>='0')&&(key[1]<='9'))      //Check Touch key 2nd is Key0-key9
                        {    
                          dd = ~key[1]                       ;
                          digitalWrite(LED0,dd&0x01)         ; //Sent data LED0   
                          dd = dd>>1                         ;       
                          digitalWrite(LED1,dd&0x01)         ; //Sent data LED1   
                          dd = dd>>1                         ;   
                          digitalWrite(LED2,dd&0x01)         ; //Sent data LED2   
                          dd = dd>>1                         ;
                          digitalWrite(LED3,dd&0x01)         ; //Sent data LED3   
                          dd = dd>>1                         ;
                          digitalWrite(LED4,dd&0x01)         ; //Sent data LED4  
                          dd = dd>>1                         ;
                          digitalWrite(LED5,dd&0x01)         ; //Sent data LED5
                            
                       }//if key[1]
                     }//if key[0]
                  } //if key[2]

                }while(key[0] != 'R') ;  //Exit Loop : Release if Not Touch the 2nd Key or Release when Touch the 2nd Key
              
                digitalWrite(LED0,HIGH)            ; //SET LED0-OFF          
                digitalWrite(LED1,HIGH)            ; //SET LED1-OFF   
                digitalWrite(LED2,HIGH)            ; //SET LED2-OFF   
                digitalWrite(LED3,HIGH)            ; //SET LED3-OFF   
                digitalWrite(LED4,HIGH)            ; //SET LED4-OFF   
                digitalWrite(LED5,HIGH)            ; //SET LED5-OFF                     
              }
             else     //Step6: When Press Key other  except key Shif ('F')(Press 1 Key)      
              {        
               //------ Step6.1 : Write Program Support Press Single Key of User ------ 
              
                 if((key[1]>='0')&&(key[1]<='9'))        //Check Touch  Key0-key9
                  {    
                    dd = ~key[1]                       ;
                    digitalWrite(LED0,dd&0x01)         ; //Sent data LED0   
                    dd = dd>>1                         ;       
                    digitalWrite(LED1,dd&0x01)         ; //Sent data LED1   
                    dd = dd>>1                         ;   
                    digitalWrite(LED2,dd&0x01)         ; //Sent data LED2   
                    dd = dd>>1                         ;
                    digitalWrite(LED3,dd&0x01)         ; //Sent data LED3   
                    dd = dd>>1                         ;
                    digitalWrite(LED4,dd&0x01)         ; //Sent data LED4  
                    dd = dd>>1                         ;
                    digitalWrite(LED5,dd&0x01)         ; //Sent data LED5
 
            
                    while(key[0] != 'R')        //wait Release Key (when key[0]=R) for Exit Loop   
                    {
                     RD_KeyCode() ;                      
                    }    
           
                   digitalWrite(LED0,HIGH)            ; //SET LED0-OFF          
                   digitalWrite(LED1,HIGH)            ; //SET LED1-OFF   
                   digitalWrite(LED2,HIGH)            ; //SET LED2-OFF   
                   digitalWrite(LED3,HIGH)            ; //SET LED3-OFF   
                   digitalWrite(LED4,HIGH)            ; //SET LED4-OFF   
                   digitalWrite(LED5,HIGH)            ; //SET LED5-OFF                 
           
                 }//if key[1]                     
              }   //else
           }     //if key[0] = P
        }        // if key[2] = 0x0D              
}




